<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SellTransaction extends Model
{
    protected $fillable = ['sale_id', 'product_id', 'payment_method', 'type', 'name', 'sell_price', 'sold_quantity', 'profit', 'warranty', 'date_time', 'tenant_id'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function sale()
    {
        return $this->belongsTo(Sale::class);
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    protected static function booted()
    {
        static::addGlobalScope('tenant', function ($builder) {
            if (app()->has('tenant')) {
                $builder->where('tenant_id', app('tenant')->id);
            }
        });
    }
}
